(function(){console.log('WhatsBoost admin ready');})();
(function(){
  function $(sel){ return document.querySelector(sel); }
  function $all(sel){ return Array.prototype.slice.call(document.querySelectorAll(sel)); }

  var NOTICE_ID = 'whatsboost-inline-notice';

  function removeNotice(){
    var el = document.getElementById(NOTICE_ID);
    if (el && el.parentNode) { el.parentNode.removeChild(el); }
  }

  function injectNotice(message, cls){
    removeNotice();
    var wrap = document.querySelector('.wrap') || document.body;
    var notice = document.createElement('div');
    notice.id = NOTICE_ID;
    notice.className = 'notice ' + cls + ' is-dismissible';
    var dismissLabel = (M.dismissLabel || 'Dismiss');
    notice.innerHTML = '<p>' + (message || '') + '</p>' +
        '<button type="button" class="notice-dismiss" aria-label="' + dismissLabel + '"></button>';

    var inserted = false;
    if (wrap) {
      var h1 = wrap.querySelector('h1');
      if (h1 && h1.parentNode) {
        if (h1.nextSibling) {
          h1.parentNode.insertBefore(notice, h1.nextSibling);
        } else {
          h1.parentNode.appendChild(notice);
        }
        inserted = true;
      }
      if (!inserted) {
        wrap.insertBefore(notice, wrap.firstChild || null);
      }
      var btn = notice.querySelector('.notice-dismiss');
      if (btn) {
        btn.addEventListener('click', function(){ removeNotice(); });
      }
      try { notice.scrollIntoView({ behavior: 'smooth', block: 'start' }); } catch(e){}
    }
  }

  var M = (window.WhatsBoostVerify && WhatsBoostVerify.messages) || {};
  function showError(message){ injectNotice(message || M.genericError || 'An error occurred.', 'notice-error'); }
  function showSuccess(message){ injectNotice(message || M.genericSuccess || 'Operation completed.', 'notice-success'); }

  // Guardar selección de cuenta vía AJAX
  function saveSelectedAccount(id){
    var ajaxUrl = (window.WhatsBoostVerify && WhatsBoostVerify.ajaxUrl) || (typeof ajaxurl !== 'undefined' ? ajaxurl : '');
    var form = new FormData();
    form.append('action','whatsboost_set_account');
    form.append('nonce', (window.WhatsBoostVerify && WhatsBoostVerify.nonce) || '');
    form.append('id', id || '');
    return fetch(ajaxUrl, { method: 'POST', credentials: 'same-origin', body: form })
      .then(function(r){ return r.json().catch(function(){ return { success:false }; }); })
      .then(function(res){
        if (res && res.success) {
          showSuccess((M.genericSuccess || 'Operación realizada.') + '');
          try { if (window.WhatsBoostVerify) { WhatsBoostVerify.currentAccount = id || ''; } } catch(e){}
          var preview = document.getElementById('whatsboost-account-preview');
          if (preview) {
            if (id) {
              var label = (M.accountPreviewLabel || 'Detected account ID:');
              preview.innerHTML = '<strong>' + label + '</strong> <code>' + escapeHtml(id) + '</code>';
            } else {
              var noPrev = (M.noAccountPreview || 'No account ID yet. Verify your key to fetch it automatically.');
              preview.innerHTML = '<em>' + noPrev + '</em>';
            }
          }
        } else {
          showError((res && res.data && res.data.message) ? res.data.message : (M.genericError || 'Ha ocurrido un error.'));
        }
        return res;
      })
      .catch(function(){ showError(M.networkError || 'Error de red.'); });
  }

  // Renderizado del selector de cuentas
  function renderAccountSelect(list, selected){
    var select = document.getElementById('whatsboost-account-select');
    var picker = document.getElementById('whatsboost-account-picker');
    if (!select || !picker) { return; }
    if (!Array.isArray(list)) { list = []; }

    // Filtrar solo cuentas que funcionan (estado exactamente "connected")
    var working = list.filter(function(it){
      var st = (it && it.status) ? String(it.status).toLowerCase() : '';
      return st === 'connected';
    });

    // Construir opciones solo con las que funcionan
    var html = '';
    if (!working.length) {
      html += '<option value="">' + escapeHtml((M.noWorkingAccounts || 'No hay cuentas conectadas. Solo aparecen aquí las que funcionan.')) + '</option>';
      select.innerHTML = html;
      return;
    }

    function shortId(id){ if (!id) return ''; if (id.length <= 16) return id; return id.substring(0,8) + '…' + id.substring(id.length-6); }
    var SW = (M.statusWorks || 'Funciona');
    var SNW = (M.statusNoWorks || 'No funciona');
    working.forEach(function(it){
      var id = (it && it.id) ? String(it.id) : '';
      var phone = (it && it.phone) ? String(it.phone) : '';
      var state = (it && it.status) ? String(it.status).toLowerCase() : '';
      var pretty = (state === 'connected') ? SW : SNW;
      var label = (phone ? phone + ' • ' : '') + shortId(id) + ' — ' + pretty;
      html += '<option value="' + escapeHtml(id) + '">' + escapeHtml(label) + '</option>';
    });
    select.innerHTML = html;

    // Determinar selección por defecto
    var valueToUse = (typeof selected === 'string') ? selected : '';
    if (!valueToUse) {
      var foundConnected = working.find(function(it){ return it && it.id; });
      if (foundConnected) { valueToUse = String(foundConnected.id); }
      if (valueToUse) {
        // Guardar automáticamente la primera que funciona como valor por defecto
        saveSelectedAccount(valueToUse);
      }
    }
    if (valueToUse) { select.value = valueToUse; }

    // Cambios del usuario
    select.addEventListener('change', function(){
      var id = select.value || '';
      saveSelectedAccount(id);
    }, { once: false });
  }

  // Renderizado de tabla de cuentas
  function renderAccountsTable(list){
    var box = document.getElementById('whatsboost-accounts-box');
    var host = document.getElementById('whatsboost-accounts-table');
    if (!box || !host) { return; }
    if (!Array.isArray(list)) { list = []; }

    // Mostrar la caja solo si hay 2 o más, según requisito "cuando tenga mas de un id_cuenta"
    if (list.length < 2) {
      host.innerHTML = '';
      box.setAttribute('hidden','');
      return;
    }

    // Construir tabla con clases WP
    var html = '';
    html += '<table class="widefat fixed striped">';
    html += '<thead><tr>' +
            '<th style="width:30%">' + (M.colTelefono || 'Teléfono') + '</th>' +
            '<th style="width:50%">' + (M.colIdCuenta || 'ID de cuenta') + '</th>' +
            '<th style="width:20%">' + (M.colEstado || 'Estado') + '</th>' +
            '</tr></thead>';
    html += '<tbody>';
    list.forEach(function(item){
      var phone = (item && item.phone) ? (item.phone + '') : '';
      var id = (item && item.id) ? (item.id + '') : '';
      var status = (item && item.status) ? (item.status + '') : '';

      // Truncar ID mostrando primeros y últimos caracteres, con puntos suspensivos
      var shortId = id;
      if (id && id.length > 16) {
        shortId = id.substring(0, 8) + '…' + id.substring(id.length - 6);
      }

      // Mapear estado a español según requisito (Funciona/No funciona)
      var stateLower = (status || '').toLowerCase();
      var pretty = (stateLower === 'connected') ? (M.statusWorks || 'Funciona') : (M.statusNoWorks || 'No funciona');
      var badgeCls = (stateLower === 'connected') ? 'tag-green' : 'tag-red';

      html += '<tr>' +
              '<td><span>' + escapeHtml(phone) + '</span></td>' +
              '<td><code title="' + escapeHtml(id) + '">' + escapeHtml(shortId) + '</code></td>' +
              '<td><span class="' + badgeCls + '">' + pretty + '</span></td>' +
              '</tr>';
    });
    html += '</tbody></table>';

    host.innerHTML = html;
    box.removeAttribute('hidden');
  }

  function escapeHtml(s){
    if (s == null) return '';
    return (s + '').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/\'/g,'&#39;');
  }

  function fetchAccountsAndRender(){
    var ajaxUrl = (window.WhatsBoostVerify && WhatsBoostVerify.ajaxUrl) || (typeof ajaxurl !== 'undefined' ? ajaxurl : '');
    var form = new FormData();
    form.append('action','whatsboost_get_accounts');
    form.append('nonce', (window.WhatsBoostVerify && WhatsBoostVerify.nonce) || '');
    return fetch(ajaxUrl, { method: 'POST', credentials: 'same-origin', body: form })
      .then(function(r){ return r.json().catch(function(){ return { success:false }; }); })
      .then(function(res){
        var list = (res && res.data && Array.isArray(res.data.waAccounts)) ? res.data.waAccounts : [];
        var selected = (res && res.data && typeof res.data.selected === 'string') ? res.data.selected : '';
        renderAccountsTable(list);
        try { renderAccountSelect(list, selected); } catch(e){}

        // Sincronizar estado en memoria
        try { if (window.WhatsBoostVerify) { WhatsBoostVerify.currentAccount = selected || ''; } } catch(e){}

        // Si no hay selección (no hay cuenta funcionando), ocultar controles y quitar aviso verde
        if (!selected) {
          hidePicker();
          hideAccountsBox();
          try { removeNotice(); } catch(e){}
          var preview = document.getElementById('whatsboost-account-preview');
          if (preview) {
            var noPrev = (M.noAccountPreview || 'No account ID yet. Verify your key to fetch it automatically.');
            preview.innerHTML = '<em>' + noPrev + '</em>';
          }
        } else {
          showPicker();
        }

        return { list: list, selected: selected };
      })
      .catch(function(){ /* silencio */ });
  }

  // Helpers para mostrar/ocultar la documentación sin recargar
  function getDocsBox(){ return document.getElementById('whatsboost-docs-container'); }
  function revealDocs(){ var b=getDocsBox(); if(!b) return; b.setAttribute('data-can-show','1'); b.removeAttribute('hidden'); try{ b.scrollIntoView({behavior:'smooth', block:'start'});}catch(e){} }
  function hideDocs(){ var b=getDocsBox(); if(!b) return; b.setAttribute('data-can-show','0'); b.setAttribute('hidden',''); }

  // Helpers de visibilidad para picker y tabla
  function getPicker(){ return document.getElementById('whatsboost-account-picker'); }
  function getAccountsBox(){ return document.getElementById('whatsboost-accounts-box'); }
  function hidePicker(){ var p=getPicker(); if(p){ p.setAttribute('hidden',''); } }
  function showPicker(){ var p=getPicker(); if(p){ p.removeAttribute('hidden'); } }
  function hideAccountsBox(){ var b=getAccountsBox(); if(b){ b.setAttribute('hidden',''); var host=document.getElementById('whatsboost-accounts-table'); if(host){ host.innerHTML=''; } } }

  // Sincronizar en carga: si PHP no lo mostró inicialmente, ocultar cuando no está verificado
  document.addEventListener('DOMContentLoaded', function(){
    var box = getDocsBox();
    var initial = box ? String(box.getAttribute('data-initial-visible') || '0') : '0';
    if (initial !== '1') {
      var v = (window.WhatsBoostVerify && parseInt(WhatsBoostVerify.currentVerified,10)) || 0;
      if (v !== 1) { hideDocs(); }
    }

    // Si la clave ya está verificada al cargar y tenemos account, mostramos picker y cargamos lista
    try {
      var verified = (window.WhatsBoostVerify && parseInt(WhatsBoostVerify.currentVerified,10)) || 0;
      var accNow = (window.WhatsBoostVerify && WhatsBoostVerify.currentAccount) ? String(WhatsBoostVerify.currentAccount).trim() : '';
      if (verified === 1 && accNow) {
        showPicker();
        fetchAccountsAndRender();
      } else {
        hidePicker();
        hideAccountsBox();
        try { removeNotice(); } catch(e){}
      }
    } catch(e){}

    // Botón de refrescar lista
    var refreshBtn = document.getElementById('whatsboost-refresh-accounts');
    if (refreshBtn) {
      refreshBtn.addEventListener('click', function(){ fetchAccountsAndRender(); });
    }
  });

  // Mostrar debajo del botón el ID actual (si existe)
  document.addEventListener('DOMContentLoaded', function(){
    var preview = $('#whatsboost-account-preview');
    if (preview && window.WhatsBoostVerify) {
      var acc = (WhatsBoostVerify.currentAccount || '').trim();
      if (acc) {
        var label = (M.accountPreviewLabel || 'Detected account ID:');
        preview.innerHTML = '<strong>' + label + '</strong> <code>' + acc + '</code>';
      }
    }
  });

  document.addEventListener('click', function(e){
    if (e.target && e.target.id === 'whatsboost-verify-btn') {
      var btn = e.target;
      var keyEl = $('#whatsboost_license_key');
      var key = keyEl ? keyEl.value.trim() : '';
      if (!key) {
        showError(M.invalidKey || 'Invalid key. Try another one or copy it again.');
        hideDocs();
        hidePicker();
        hideAccountsBox();
        return;
      }

      // Confirmar sustitución si ya existe una clave guardada y es distinta
      try {
        var savedKey = (window.WhatsBoostVerify && WhatsBoostVerify.currentKey) ? String(WhatsBoostVerify.currentKey).trim() : '';
        if (savedKey && key && key !== savedKey) {
          var raw = (M.replaceKeyConfirm || 'Vas a reemplazar la clave guardada por la nueva.\n\nSi continúas, la clave anterior se sustituirá por esta.\n\n¿Quieres continuar?');
          // Normaliza: convierte \\n en saltos de línea reales por si llegan escapados
          var text = String(raw).replace(/\\n/g, '\n');
          var okReplace = window.confirm(text);
          if (!okReplace) { return; }
        }
      } catch(e){}

      removeNotice();
      btn.disabled = true;
      var originalText = btn.textContent;
      btn.textContent = (M.verifying || 'Verifying...');

      var form = new FormData();
      form.append('action','whatsboost_verify_key');
      form.append('nonce', (window.WhatsBoostVerify && WhatsBoostVerify.nonce) || '');
      form.append('key', key);

      var ajaxUrl = (window.WhatsBoostVerify && WhatsBoostVerify.ajaxUrl) || (typeof ajaxurl !== 'undefined' ? ajaxurl : '');
      fetch(ajaxUrl, { method: 'POST', credentials: 'same-origin', body: form })
          .then(function(r){ return r.json().catch(function(){ return { success:false }; }); })
          .then(function(res){
            var ok = (res && typeof res.success !== 'undefined') ? !!res.success : false;
            var msg = (res && res.data && res.data.message) ? res.data.message : (res && res.message ? res.message : '');
            // Actualizar estado en memoria de la clave (el backend la guarda siempre)
            try { if (window.WhatsBoostVerify) { WhatsBoostVerify.currentKey = key; } } catch(e){}
            if (ok) {
              showSuccess(msg || (M.verifiedMsg || 'Key verified.'));
              if (keyEl) { keyEl.setAttribute('aria-invalid','false'); }
              btn.textContent = (M.verified || 'Key verified');

              // Ocultar inmediatamente el aviso global de "no hay clave"
              try {
                var noKey = document.getElementById('whatsboost-no-key-notice');
                if (noKey && noKey.parentNode) { noKey.parentNode.removeChild(noKey); }
              } catch(e){}

              // Comprobación de cuenta vs define WHATSBOOST_ACCOUNT
              try {
                var accountFromApi = (res && res.data && res.data.account) ? (res.data.account + '') : '';
                var definedAccount = (res && res.data && res.data.definedAccount) ? (res.data.definedAccount + '') : '';
                var matches = !!(res && res.data && res.data.matchesAccount);

                // Actualizar el bloque de vista previa bajo el botón
                var preview = $('#whatsboost-account-preview');
                var toShow = '';
                if (preview) {
                  toShow = (accountFromApi || definedAccount || '').trim();
                  if (toShow) {
                    var label2 = (M.accountPreviewLabel || 'Detected account ID:');
                    preview.innerHTML = '<strong>' + label2 + '</strong> <code>' + toShow + '</code>';
                  } else {
                    var noPrev = (M.noAccountPreview || 'No account ID yet. Verify your key to fetch it automatically.');
                    preview.innerHTML = '<em>' + noPrev + '</em>';
                  }
                }
                // Sync current account in memory so future actions reflect latest state
                try { if (window.WhatsBoostVerify) { WhatsBoostVerify.currentAccount = (toShow || ''); } } catch(e){}

                // Mostrar/ocultar documentación en caliente según disponibilidad de cuenta
                var hasAnyAccountNow = (accountFromApi && accountFromApi.trim()) || (definedAccount && definedAccount.trim());
                if (!hasAnyAccountNow) {
                  revealDocs();
                  // Sin cuenta aún: ocultar selector y tabla
                  hidePicker();
                  hideAccountsBox();
                  try { removeNotice(); } catch(e){}
                } else {
                  hideDocs();
                  // Con cuenta: mostrar selector y cargar lista
                  showPicker();
                  fetchAccountsAndRender();
                }

                // Mostrar/ocultar el aviso global de falta de número en caliente según si hay account
                try {
                  var hasAnyAccountNow = (accountFromApi && accountFromApi.trim()) || (definedAccount && definedAccount.trim());
                  var existing = document.getElementById('whatsboost-account-missing-notice');
                  if (hasAnyAccountNow) {
                    // Tenemos account: eliminar el aviso si existe
                    if (existing && existing.parentNode) { existing.parentNode.removeChild(existing); }
                  } else {
                    // No hay account: asegurar que el aviso esté presente
                    if (!existing) {
                      var container = document.querySelector('.wrap') || document.body;
                      if (container) {
                        var notice = document.createElement('div');
                        notice.id = 'whatsboost-account-missing-notice';
                        notice.className = 'notice notice-error';
                        notice.style.borderLeftColor = '#c00';
                        var prefix = (M.accountNoticePrefix || 'WhatsBoost: You need to add your phone number so WhatsApps can be sent from your phone.');
                        var settingsUrl = (window.WhatsBoostVerify && WhatsBoostVerify.settingsUrl) ? WhatsBoostVerify.settingsUrl : '#';
                        notice.innerHTML = '<p style="font-size:14px;">' + prefix + '</p>' +
                                           '<p style="margin-top:6px;">' +
                                           '<a class="button button-primary" href="' + settingsUrl + '">' + (M.openSettings || 'Abrir ajustes de WhatsBoost') + '</a>' +
                                           '</p>';
                        var wrapH1 = container.querySelector('h1');
                        if (wrapH1 && wrapH1.parentNode) {
                          wrapH1.parentNode.insertBefore(notice, wrapH1.nextSibling);
                        } else {
                          container.insertBefore(notice, container.firstChild || null);
                        }
                      }
                    }
                  }
                } catch(e){}

                // Nuevo comportamiento: si no hay account en la API ni definida
                // mostramos la documentación (ya hecho arriba) y un mensaje de éxito menor,
                // en vez de lanzar un error que obliga al usuario a recargar.
                if (!accountFromApi) {
                  if (definedAccount) {
                    showSuccess(M.successUseConfigured || "Key verified. We'll use your configured number/account.");
                  } else {
                    // No account anywhere: docs shown; not an error
                    showSuccess(M.verifiedMsg || 'Key verified.');
                  }
                } else if (!definedAccount) {
                  showError((M.needPhoneWithAccount || 'You need to add your phone number to send WhatsApps. Copy this key and paste it in whatsboost.php (WHATSBOOST_ACCOUNT):') + '\n' + accountFromApi);
                } else if (!matches) {
                  showError((M.mismatchedAccount || 'La clave pertenece a otro número/cuenta. Actualiza whatsboost.php con esta clave para enviar desde tu número:') + '\n' + accountFromApi);
                } else {
                  showSuccess(M.allGood || 'Todo correcto. Enviaremos WhatsApps desde tu número.');
                }

                // Renderizar tabla de múltiples cuentas si viene en la respuesta
                try {
                  var list = (res && res.data && Array.isArray(res.data.waAccounts)) ? res.data.waAccounts : [];
                  renderAccountsTable(list);
                } catch(e){}
              } catch(e){}
            } else {
              showError(msg || (M.invalidLicense || 'Clave de licencia no válida. Inténtalo de nuevo.'));
              hideDocs();
              hidePicker();
              hideAccountsBox();
              if (keyEl) { keyEl.setAttribute('aria-invalid','true'); }

              // Limpiar vista previa del ID de cuenta y estado en memoria
              try {
                if (window.WhatsBoostVerify) { WhatsBoostVerify.currentAccount = ''; }
                var preview = document.querySelector('#whatsboost-account-preview');
                if (preview) {
                  var noPrev = (M.noAccountPreview || 'No account ID yet. Verify your key to fetch it automatically.');
                  preview.innerHTML = '<em>' + noPrev + '</em>';
                }
              } catch(e){}

              btn.textContent = originalText;
            }
          })
          .catch(function(){
            showError(M.networkError || 'Error de red.');
            hideDocs();
            btn.textContent = originalText;
          })
          .finally(function(){
            btn.disabled = false;
          });
    }
  });
})();
