<?php
if (!defined('ABSPATH')) { exit; }
?>
<div class="wrap">
    <?php include WHATSBOOST_DIR . 'includes/admin-views/partials/header.php'; ?>
    <h1><?php esc_html_e('Documentación', 'whatsboost'); ?></h1>

    <div style="margin:16px 0;padding:14px;border:2px solid #2271b1;background:#f0f6fc;border-radius:8px;">
        <p style="margin:0;font-weight:600;">
            <?php echo esc_html__('Plan Gratis activo al registrarte o iniciar sesión.', 'whatsboost'); ?>
        </p>
    </div>

    <?php
    // Rutas de imágenes del plugin
    $img_dir = WHATSBOOST_DIR . 'assets/img/';
    $img_url = WHATSBOOST_URL . 'assets/img/';
    ?>

    <h2 style="margin-top:8px;">&nbsp;<?php esc_html_e('Guía rápida (3 pasos)', 'whatsboost'); ?></h2>

    <!-- PASO 1 -->
    <h3 style="margin-top:12px;">1) <?php echo esc_html__('Regístrate o inicia sesión', 'whatsboost'); ?></h3>
    <ul style="margin:0 0 10px 18px;list-style:disc;">
        <li>
            <?php echo esc_html__('Si no tienes cuenta:', 'whatsboost'); ?>
            <a href="https://whatsboost.net/dashboard/auth/register" target="_blank" rel="noopener noreferrer"><?php echo esc_html__('crear cuenta', 'whatsboost'); ?></a>.
        </li>
        <?php if (file_exists($img_dir . 'registrarse.PNG')) : ?>
            <div class="whatsboost-img-wrap">
                <img class="whatsboost-img" src="<?php echo esc_url($img_url . 'registrarse.PNG'); ?>" alt="<?php echo esc_attr__('Pantalla de registro', 'whatsboost'); ?>" loading="lazy">
            </div>
        <?php endif; ?>
        <li>
            <?php echo esc_html__('Si ya tienes cuenta:', 'whatsboost'); ?>
            <a href="https://whatsboost.net/dashboard/auth" target="_blank" rel="noopener noreferrer"><?php echo esc_html__('inicia sesión', 'whatsboost'); ?></a>.
        </li>
        <?php if (file_exists($img_dir . 'iniciarSesion.PNG')) : ?>
            <div class="whatsboost-img-wrap">
                <img class="whatsboost-img" src="<?php echo esc_url($img_url . 'iniciarSesion.PNG'); ?>" alt="<?php echo esc_attr__('Pantalla de iniciar sesión', 'whatsboost'); ?>" loading="lazy">
            </div>
        <?php endif; ?>
    </ul>

    <!-- PASO 2 -->
    <h3 style="margin-top:18px;">2) <?php echo esc_html__('Crea una clave (API Key)', 'whatsboost'); ?></h3>
    <ul style="margin:0 0 10px 18px;list-style:disc;">
        <li>
            <?php echo wp_kses_post(__('1-En el menú izquierdo entra en <strong>CLAVES&nbsp;API</strong> o ve a', 'whatsboost')); ?>
            <a href="https://whatsboost.net/dashboard/tools/keys" target="_blank" rel="noopener noreferrer"><?php echo esc_html__('esta página', 'whatsboost'); ?></a>.
        </li>
        <li><?php echo wp_kses_post(__('2-Pulsa <strong>“Añadir clave”</strong>.', 'whatsboost')); ?></li>
        <?php if (file_exists($img_dir . 'pintada1.PNG')) : ?>
            <div class="whatsboost-img-wrap">
                <img class="whatsboost-img" src="<?php echo esc_url($img_url . 'pintada1.PNG'); ?>" alt="<?php echo esc_attr__('Formulario para nombrar la clave', 'whatsboost'); ?>" loading="lazy">
            </div>
        <?php endif; ?>
        <li><?php echo esc_html__('Escribe un nombre (cualquiera, es solo para reconocerla) y guarda.', 'whatsboost'); ?></li>
        <?php if (file_exists($img_dir . 'pintada3.PNG')) : ?>
            <div class="whatsboost-img-wrap">
                <img class="whatsboost-img" src="<?php echo esc_url($img_url . 'pintada2.PNG'); ?>" alt="<?php echo esc_attr__('Poner nombre', 'whatsboost'); ?>" loading="lazy">
            </div>
        <?php endif; ?>
        <li><?php echo esc_html__('¡Hecho! Verás tu nueva clave.', 'whatsboost'); ?></li>
        <?php if (file_exists($img_dir . 'pintada3.PNG')) : ?>
            <div class="whatsboost-img-wrap">
                <img class="whatsboost-img" src="<?php echo esc_url($img_url . 'pintada3.PNG'); ?>" alt="<?php echo esc_attr__('Clave creada', 'whatsboost'); ?>" loading="lazy">
            </div>
        <?php endif; ?>
    </ul>

    <!-- PASO 3 -->
    <h3 style="margin-top:18px;">3) <?php echo esc_html__('Copia tu clave y pégala en WordPress', 'whatsboost'); ?></h3>
    <ul style="margin:0 0 10px 18px;list-style:disc;">
        <li><?php echo wp_kses_post(__('En <strong>CLAVES&nbsp;API</strong>, copia la clave que quieras usar.', 'whatsboost')); ?></li>
        <?php if (file_exists($img_dir . 'pintada4.PNG')) : ?>
            <div class="whatsboost-img-wrap">
                <img class="whatsboost-img" src="<?php echo esc_url($img_url . 'pintada4.PNG'); ?>" alt="<?php echo esc_attr__('Copiar la clave', 'whatsboost'); ?>" loading="lazy">
            </div>
        <?php endif; ?>
        <li><?php echo esc_html__('Vuelve a tu WordPress → menú WhatsBoost → pega la clave en el campo de abajo y guarda.', 'whatsboost'); ?></li>
        <?php if (file_exists($img_dir . 'Captura de pantalla 2025-10-22 171923.png')) : ?>
            <div class="whatsboost-img-wrap">
                <img class="whatsboost-img" src="<?php echo esc_url($img_url . 'Captura de pantalla 2025-10-22 171923.png'); ?>" alt="<?php echo esc_attr__('Dónde pegar la clave en el plugin - paso 1', 'whatsboost'); ?>" loading="lazy">
            </div>
        <?php endif; ?>
        <?php if (file_exists($img_dir . 'Captura de pantalla 2025-10-22 171936.png')) : ?>
            <div class="whatsboost-img-wrap">
                <img class="whatsboost-img" src="<?php echo esc_url($img_url . 'Captura de pantalla 2025-10-22 171936.png'); ?>" alt="<?php echo esc_attr__('Dónde pegar la clave en el plugin - paso 2', 'whatsboost'); ?>" loading="lazy">
            </div>
        <?php endif; ?>
    </ul>

    <hr style="margin:18px 0;">

    <p>
        <a class="button" href="<?php echo esc_url( admin_url('admin.php?page=whatsboost') ); ?>"><?php esc_html_e('Ir a Ajustes', 'whatsboost'); ?></a>
    </p>

    <?php include WHATSBOOST_DIR . 'includes/admin-views/partials/footer.php'; ?>
</div>