<?php
// settings-page.php - view para la página de ajustes de WhatsBoost
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('manage_options')) { return; }
?>
<div class="wrap">
    <?php include WHATSBOOST_DIR . 'includes/admin-views/partials/header.php'; ?>

    <h1 class="whatsboost-page-title"><?php esc_html_e('Ajustes de WhatsBoost', 'whatsboost'); ?></h1>
    <form method="post" action="<?php echo esc_url(admin_url('options.php')); ?>">

        <?php
        // Imprime la sección/campo para pegar la clave (página 'whatsboost')
        settings_fields('whatsboost_group');
        do_settings_sections('whatsboost');
        // Ya no mostramos botón de "Guardar cambios": la verificación usará el valor del campo
        ?>
    </form>
    <div class="whatsboost-actions">
        <button type="button" class="button button-primary" id="whatsboost-verify-btn"><?php esc_html_e('Verificar clave', 'whatsboost'); ?></button>
    </div>


    <div id="whatsboost-account-preview">
        <?php
        // Opción A: usar SIEMPRE la opción viva, no la constante
        $current_account = (string) get_option('whatsboost_account', '');
        if ($current_account) {
            echo '<strong>' . esc_html__('ID de cuenta detectado:', 'whatsboost') . '</strong> <code>' . esc_html($current_account) . '</code>';
        } else {
            echo '<em>' . esc_html__('No hay ID de cuenta aún. Verifica tu clave para obtenerlo automáticamente.', 'whatsboost') . '</em>';
        }
        ?>
    </div>

    <?php
    // Mostrar el selector SOLO si la clave está verificada y hay un ID de cuenta guardado
    $verified       = (int) get_option('whatsboost_license_verified', 0);
    $account_option = trim((string) get_option('whatsboost_account', ''));
    $show_picker    = ($verified === 1 && $account_option !== '');
    ?>
    <div id="whatsboost-account-picker" class="porto-admin-card" style="margin-top:16px; padding:12px; border:1px solid #e5e7eb; border-radius:8px;" <?php echo $show_picker ? '' : 'hidden'; ?> data-initial-visible="<?php echo $show_picker ? '1' : '0'; ?>">
        <label for="whatsboost-account-select" style="display:block; font-weight:600; margin-bottom:6px;">
            <?php echo esc_html__('Número para enviar WhatsApps', 'whatsboost'); ?>
        </label>
        <p id="whatsboost-account-subtitle" class="description" style="margin:4px 0 8px; color:#374151;">
            <?php echo esc_html__('Este es el número que usaremos para enviar WhatsApps a tus clientes. Si lo cambias aquí, los mensajes saldrán de ese número.', 'whatsboost'); ?>
        </p>
        <select id="whatsboost-account-select" class="regular-text" style="min-width:320px; max-width:100%;">
            <option value=""><?php echo esc_html__('Cargando cuentas...', 'whatsboost'); ?></option>
        </select>
        <p id="whatsboost-account-help" class="description" style="margin-top:6px;">
            <?php echo esc_html__('Solo verás en este desplegable las cuentas que funcionan (conectadas). Por defecto usaremos la primera que funcione; si tienes varias, elige aquí la que quieras usar.', 'whatsboost'); ?>
        </p>
    </div>

    <div id="whatsboost-accounts-box" style="margin-top:16px;" hidden>
        <h2 style="margin-top:0;"><?php echo esc_html__('Cuentas de WhatsApp', 'whatsboost'); ?></h2>
        <div id="whatsboost-accounts-table"></div>
        <p class="description" style="margin:10px 0 0; color:#374151;">
            <?php echo wp_kses_post(__('Si un número aparece como <strong>No funciona</strong>, es porque no está conectado en <a href="https://whatsboost.net/dashboard/hosts/whatsapp" target="_blank" rel="noopener">WhatsBoost → Hosts → WhatsApp</a>. Entra allí y vuelve a vincularlo; cuando esté conectado, aparecerá aquí como <strong>Funciona</strong>.', 'whatsboost')); ?>
        </p>
        <p style="margin-top:8px;"><button type="button" class="button" id="whatsboost-refresh-accounts"><?php echo esc_html__('Actualizar lista', 'whatsboost'); ?></button></p>
    </div>

    <?php
    // Mostrar SIEMPRE el bloque de documentación en el DOM y controlar su visibilidad
    $verified       = (int) get_option('whatsboost_license_verified', 0);
    $account_option = trim((string) get_option('whatsboost_account', ''));
    $show_docs_now  = ($verified === 1 && $account_option === '');
    $img_base       = WHATSBOOST_URL . 'assets/img/';
    ?>
    <div id="whatsboost-docs-container" class="whatsboost-docs-container" <?php echo $show_docs_now ? '' : 'hidden'; ?> data-initial-visible="<?php echo $show_docs_now ? '1' : '0'; ?>" data-can-show="<?php echo $show_docs_now ? '1' : '0'; ?>">
        <div class="whatsboost-docs-note whatsboost-docs-note-warning whatsboost-mt-12" role="note" aria-label="WhatsBoost">
            <p>
                <strong><?php esc_html_e('WhatsBoost', 'whatsboost'); ?>:</strong>
                <?php echo esc_html__('Tu clave está verificada, pero falta que pongas tu número de teléfono para que enviemos WhatsApps desde tu propio número.', 'whatsboost'); ?>
            </p>
        </div>
        <div class="whatsboost-docs-callout porto-admin-card">
            <div class="heder">
                <h2 class="whatsboost-docs-h2"><?php echo esc_html__('¿Aún no tienes tu número conectado?', 'whatsboost'); ?></h2>
                <p class="whatsboost-docs-desc"><?php echo esc_html__('Sigue estos pasos para conectar tu WhatsApp y que podamos enviar mensajes desde tu número.', 'whatsboost'); ?></p>
            </div>
            <div class="whatsboost-docs-flex">
                <div class="whatsboost-docs-col">
                    <ol class="whatsboost-docs-ol">
                        <li>
                            <?php echo esc_html__('Inicia sesión en tu cuenta:', 'whatsboost'); ?>
                            <a href="https://whatsboost.net/dashboard/auth" target="_blank" rel="noopener noreferrer" title="Inicio sessión de whatsboost">https://whatsboost.net/dashboard/auth</a>
                            <div class="whatsboost-mt-8">
                                <img class="whatsboost-docs-img" src="<?php echo esc_url($img_base . 'iniciarSesion.PNG'); ?>" alt="<?php echo esc_attr__('Inicia sesión en WhatsBoost', 'whatsboost'); ?>">
                            </div>
                        </li>
                    </ol>
                </div>
            </div>
        </div>

        <div class="whatsboost-docs-callout porto-admin-card">
            <div class="whatsboost-docs-flex">
                <div class="whatsboost-docs-col">
                    <ol class="whatsboost-docs-ol">
                        <li style="margin:12px 0;">
                            <?php echo wp_kses_post(__('En el menú de la izquierda, entra en <strong>Hosts (1) → WhatsApp</strong>, o ve directo a', 'whatsboost')); ?>
                            <a href="https://whatsboost.net/dashboard/hosts/whatsapp" target="_blank" rel="noopener noreferrer"><?php echo esc_html__('esta URL', 'whatsboost'); ?></a>.
                            <?php echo wp_kses_post(__('Luego pulsa <strong>“Añadir cuenta” (2)</strong> como en la captura.', 'whatsboost')); ?>
                            <div style="margin-top:8px;">
                                <img class="whatsboost-docs-img" src="<?php echo esc_url($img_base . 'tlf1.PNG'); ?>" alt="<?php echo esc_attr__('Paso: Hosts (1) y Añadir cuenta (2)', 'whatsboost'); ?>">
                            </div>
                        </li>
                        <li style="margin:12px 0;">
                            <?php echo wp_kses_post(__('Haz clic en <strong>Vincular cuenta</strong> y escanea el QR con tu WhatsApp.', 'whatsboost')); ?>
                            <div class="whatsboost-docs-row">
                                <img class="whatsboost-docs-img" src="<?php echo esc_url($img_base . 'Captura de pantalla 2025-10-23 100939.png'); ?>" alt="<?php echo esc_attr__('QR para vincular', 'whatsboost'); ?>">
                                <img class="whatsboost-docs-img" src="<?php echo esc_url($img_base . 'Captura de pantalla 2025-10-23 100958.png'); ?>" alt="<?php echo esc_attr__('Paso: Vincular cuenta', 'whatsboost'); ?>">
                            </div>
                        </li>
                    </ol>
                    <p style="margin-top:12px; color:#334155;"><?php echo esc_html__('Cuando tu cuenta esté conectada, vuelve aquí y pulsa “Verificar clave”. Detectaremos tu ID automáticamente.', 'whatsboost'); ?></p>
                    <div style="margin-top:16px;">
                        <h3 style="margin:0 0 8px;"><?php echo esc_html__('Vídeo: cómo escanear el QR y vincular tu WhatsApp', 'whatsboost'); ?></h3>
                        <p style="margin:0 0 10px; color:#374151;"><?php echo esc_html__('Si no sabes cómo escanear el QR, este vídeo te lo muestra paso a paso.', 'whatsboost'); ?></p>
                        <div style="position:relative; width:100%; max-width:720px; height:0; padding-bottom:56.25%; background:#000; border-radius:8px; overflow:hidden;">
                            <iframe src="https://www.youtube.com/embed/sLV8Mhd_l_Y" title="<?php echo esc_attr__('Vincular dispositivo secundario de WhatsApp en WhatsBoost', 'whatsboost'); ?>" style="position:absolute; inset:0; width:100%; height:100%; border:0;" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                    </div>
                </div>
                <aside style="flex:0 0 320px; min-width:260px; max-width:420px; background:#ffffff; border:1px solid #e5e7eb; border-radius:8px; padding:14px;">
                    <h3 style="margin-top:0;"><?php echo esc_html__('Consejo', 'whatsboost'); ?></h3>
                    <p style="margin:8px 0; color:#374151;"><?php echo wp_kses_post(__('Si ya tienes la sesión de WhatsApp Web abierta en tu móvil, el QR se vincula en segundos. Asegúrate de que tu línea aparece como <strong>connected</strong> en el panel.', 'whatsboost')); ?></p>
                    <p style="margin:8px 0; color:#374151;"><?php echo esc_html__('Tras vincular, el ID único se guardará aquí como “ID de cuenta detectado”.', 'whatsboost'); ?></p>
                </aside>
            </div>
        </div>
        <script>
            (function(){
                // Lightbox minimal y sin dependencias para imágenes de la documentación
                var imgs = document.querySelectorAll('.whatsboost-docs-callout img.whatsboost-docs-img');
                if (!imgs.length) { return; }

                var overlay = document.createElement('div');
                overlay.className = 'whatsboost-lightbox-overlay';
                overlay.setAttribute('role', 'dialog');
                overlay.setAttribute('aria-modal', 'true');
                overlay.setAttribute('aria-hidden', 'true');

                var big = document.createElement('img');
                big.className = 'whatsboost-lightbox-img';
                big.alt = '';

                var closeBtn = document.createElement('button');
                closeBtn.type = 'button';
                closeBtn.className = 'whatsboost-lightbox-close';
                closeBtn.textContent = '<?php echo esc_js( esc_html__('Cerrar (Esc)', 'whatsboost') ); ?>';

                overlay.appendChild(big);
                overlay.appendChild(closeBtn);
                document.body.appendChild(overlay);

                function open(src, alt){
                    big.src = src;
                    if (alt) big.alt = alt;
                    overlay.classList.add('is-open');
                    overlay.setAttribute('aria-hidden', 'false');
                    document.addEventListener('keydown', onKey);
                }
                function close(){
                    overlay.classList.remove('is-open');
                    overlay.setAttribute('aria-hidden', 'true');
                    big.removeAttribute('src');
                    document.removeEventListener('keydown', onKey);
                }
                function onKey(e){ if (e.key === 'Escape') { close(); } }

                overlay.addEventListener('click', function(e){
                    // Cierra si se hace click fuera de la imagen o en el botón cerrar
                    if (e.target === overlay || e.target === closeBtn) { close(); }
                });
                big.addEventListener('click', function(e){
                    // Evita que un click en la imagen cierre el overlay
                    e.stopPropagation();
                });

                imgs.forEach(function(img){
                    img.addEventListener('click', function(){ open(img.src, img.alt || ''); });
                });
            })();
        </script>
    </div>

    <?php include WHATSBOOST_DIR . 'includes/admin-views/partials/footer.php'; ?>
</div>
