<?php
namespace WhatsBoost\Rest;

use WP_REST_Controller;
use WP_REST_Request;
use WP_REST_Response;

if (!defined('ABSPATH')) { exit; }

final class Rest_Controller extends WP_REST_Controller {
    public function __construct() {
        $this->namespace = 'whatsboost/v1';
        $this->rest_base = 'demo';
    }

    public function register_routes(): void {
        register_rest_route($this->namespace, '/' . $this->rest_base, [
            [
                'methods'  => 'GET',
                'callback' => [$this, 'get_demo'],
                'permission_callback' => '__return_true',
            ],
        ]);
    }

    public function get_demo(WP_REST_Request $request): WP_REST_Response {
        return new WP_REST_Response(['ok' => true, 'time' => time()], 200);
    }
}
