<?php
/**
 * Plugin Name: WhatsBoost
 * Description: WhatsBoost envía por WhatsApp avisos automáticos de WooCommerce (pedido recibido, en proceso, enviado, etc.). Personaliza plantillas con datos del pedido y mantén a tus clientes informados en tiempo real.
 * Version: 0.1.0
 * Author: ALMCSECURITY S.L.U.
 * Author URI: https://almcsecurity.com/
 * Plugin URI: https://almcsecurity.com/whatsboost
 * Requires PHP: 8.1
 * Requires at least: 6.0
 * Text Domain: whatsboost
 * Domain Path: /languages
 * License: GPLv2 or later
 */

if (!defined('ABSPATH')) { exit; }

const WHATSBOOST_VERSION = '0.1.0';
const WHATSBOOST_FILE = __FILE__;

define('WHATSBOOST_DIR', plugin_dir_path(__FILE__));
define('WHATSBOOST_URL', plugin_dir_url(__FILE__));

// Cuenta para el servicio de WhatsApp: se toma de la opción guardada tras verificar la clave
if (!defined('WHATSBOOST_ACCOUNT')) {
    define('WHATSBOOST_ACCOUNT', get_option('whatsboost_account', ''));
}

// Carga Composer si existe
$autoload = WHATSBOOST_DIR . 'vendor/autoload.php';
if (file_exists($autoload)) {
    require_once $autoload;
}

// Carga clases base
require_once WHATSBOOST_DIR . 'includes/class-activator.php';
require_once WHATSBOOST_DIR . 'includes/class-deactivator.php';
require_once WHATSBOOST_DIR . 'includes/class-whatsboost.php';

// Activación/Desactivación
register_activation_hook(__FILE__, ['WhatsBoost\\Activator', 'activate']);
register_deactivation_hook(__FILE__, ['WhatsBoost\\Deactivator', 'deactivate']);

// Bootstrap
add_action('plugins_loaded', static function () {
    (new WhatsBoost\initBoost())->init();
});
